#version 330
#extension GL_EXT_gpu_shader4 : enable
//SDF Soft Shadows & AOMod01.fsh  by   Assossa

//https://www.shadertoy.com/view/3lXyWs
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define RAYMARCH_STEPS 64
#define FAR_PLANE 10.
#define AO_STEPS 12
#define AO_MAX_DIST 4.
#define FLOOR_SCALE 4.
#define CAMERA_SPEED 0.02

vec2 cameraPosition(float t) {
    return vec2(
        cos(t * CAMERA_SPEED) * 100.,
        sin(t * CAMERA_SPEED) * 100.
    );
}

mat3 viewMatrix(vec3 eye, vec3 lookAt) {
    vec3 f = normalize(lookAt - eye);
    vec3 s = normalize(cross(f, vec3(0,1,0)));
    vec3 u = cross(s, f);
    return mat3(s, u, f);
}

float box(vec3 p, vec3 b) {
    vec3 q = abs(p) - b;
    return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0);
}

float scene(vec3 p) {
    vec2 intPos = floor(p.xz * FLOOR_SCALE);
    float boxScale = 1. / FLOOR_SCALE;
    
    float dist = 2. * FAR_PLANE;
    for(int x = -1; x <= 1; ++x) {
        for(int y = -1; y <= 1; ++y) {
            vec2 adjPos = intPos + vec2(x, y);
            ivec2 texUV = ivec2(mod(adjPos, 256.));
            float height = texelFetch(iChannel0, texUV, 0).r * 0.2 + 0.1;
            vec3 boxPos = vec3((adjPos + 0.5) * boxScale, 0.).xzy;
            dist = min(dist, box(p - boxPos, vec3(boxScale * 0.5, height, boxScale * 0.5)));
        }
    }
    
    vec3 objPos = p - vec3(cameraPosition(iTime + 1.), .5).xzy - vec3(0, sin(iTime * 2.) * .1 + 0.05, 0);
    float obj = max(
        box(objPos, vec3(1., .1, 1.)),
        length(objPos) - .8
    );
    
    return min(dist, obj);
}

vec3 sceneNormal(vec3 p) {
    vec2 e = vec2(0.01, 0.);
    return normalize(vec3(
    	scene(p + e.xyy) - scene(p - e.xyy),
        scene(p + e.yxy) - scene(p - e.yxy),
        scene(p + e.yyx) - scene(p - e.yyx)
    ));
}

float raymarch(vec3 p, vec3 d) {
    float dist = 0.0;
    for(int i = 0; i < RAYMARCH_STEPS; ++i) {
        dist += scene(p + d * dist);
    }
    return dist;
}

float occlusion(vec3 p) {
    vec3 nml = sceneNormal(p);
    float scale = AO_MAX_DIST / pow(2., float(AO_STEPS));
    
    float ocl = 0.0;
    for(int i = 1; i <= AO_STEPS; ++i) {
        float dist = pow(2., float(i)) * scale;
        ocl += 1. - (max(0., scene(p + nml * dist)) / dist);
    }
    
    return ocl / float(AO_STEPS);
}

void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord) 
{
    vec2 uv = (2. * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
    
    vec3 camPos = vec3(cameraPosition(iTime), 1.).xzy;
    vec3 camFocus = vec3(cameraPosition(iTime + 1.), 0.).xzy;
    vec3 camDir = viewMatrix(camPos, camFocus) * normalize(vec3(uv, 1));
    
    float dist = raymarch(camPos, camDir);
    float foreground = 1. - smoothstep(FAR_PLANE, FAR_PLANE + 1., dist);
    
    float ocl = occlusion(camPos + camDir * dist);
    
    gl_FragColor = vec4(1. - ocl) * foreground;
}